﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;
using UnityEngine;

//BuildingModel represents a single entry in BuildingsInfo for a particular building
public class BuildingModel
{
    public string Path { get; private set; }
    public string ID { get; private set; }

    public BuildingModel()
    {

    }

    public virtual bool Parse(XElement modelElem)
    {
        try
        {
            Path = modelElem.Attribute("Path").Value;
            ID = modelElem.Attribute("ID").Value;
            return true;
        }

        catch(Exception ex)
        {
            Debug.LogError("ERROR: Caught an exception when parsing building model. The exception is: " + ex);
            return false;
        }
    }
}